<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

interface InterfacePostSetter
{
    /**
     * @return static 
     */
    public function setId(string $id);

    /**
     * @return static 
     */
    public function setOwnerUserId(string $ownerUserId);

    /**
     * @return static 
     */
    public function setDisplayCaption(string $displayCaption);

    /**
     * @return static 
     */
    public function setDisplayLocation(string $displayLocation);

    /**
     * @return static 
     */
    public function setDisplayContent(PostDisplayContentDTO $displayContent);

    /**
     * @return static 
     */
    public function setCacheLikesCount(string $cacheLikesCount);

    /**
     * @return static 
     */
    public function setMetaHashtags(PostMetaHashtagsDTO $metaHashtags);

    /**
     * @return static 
     */
    public function setCacheCommentsCount(string $cacheCommentsCount);

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration);

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate);
}
